package FSAComponents;

public class VetoableSymbolEvent extends SymbolEvent
{
  private boolean vetoed;
  private String vetoMsg;

  public VetoableSymbolEvent(Object source, int type, Character[] symbols)
  {
    super(source, type, symbols);
    vetoed = false;
    vetoMsg = null;
  }

  public void veto(String msg)
  {
    vetoed = true;
    vetoMsg = msg;
  }

  public boolean isVetoed()
  {
    return vetoed;
  }

  public String getMessage()
  {
    return vetoMsg;
  }
}
