
/**
 * Parser - this class deals with parsing a regular expression into a parse tree
 *     that it can be processed into a FSA. The Grammar it uses can be found in 
 *     regExpGrammar.txt.
 * 
 * @author Brad Pascoe
 * @version 6/10/2003
 */
import FSAComponents.*;
import java.io.*;

public class Parser
{
    private Reader scanner;  // used to process regular expression string
    SymTable symbolTable;
    //File output;
    //PrintWriter pout;
    FSAOperations f;
    FSAOperations2 f2;
    //private boolean isValid; 
    
    public Parser()
    {
    }
    
    public StateMachine parse(String input, int newAlph, char [] alph) throws Exception
    {
        scanner = new Reader(input, newAlph, alph);
        symbolTable = new SymTable(10); 
        //isValid = true;
        //output = new File("C:/Pascoe/Research03/testFiles/parsetree.txt");
        //pout = new PrintWriter(new FileWriter(output));
        f = new FSAOperations();
        f2 = new FSAOperations2();
        StateMachine T = start();
        
        if (newAlph == Reader.KEEPOLD)
        {
            for (int i = 0; i < alph.length; i++)
            {
                try
                {
                    //System.out.println(alph[i]);
                    Character c = new Character(alph[i]);
                    T.getAlphabet().addSymbol(c);
                }
                catch (Exception e)
                {
                    //System.out.println(e);
                }
            }
        }
        
        //FSAFile newFile = new FSAFile(T);
	    //File outFile = new File("C:/Pascoe/Research03/testFiles/fsaT.xml");
	    //FileOutputStream out = new FileOutputStream(outFile);
	    //newFile.saveFile(out);
        //pout.close();
        
        return T;
    }
    
    public char [] getScannerAlph()
    {
        return scanner.getAlph();
    }
    
    private StateMachine start() throws Exception
    {
        //pout.println("<start> -> <regularSystem>");
        StateMachine T = regularSystem();
        if (scanner.isEOF(scanner.currentToken())) /*|| scanner.isLambda(scanner.currentToken()))*/
        {
            //pout.println("Entered Expression is Valid");
            //System.out.println("Entered Expression is Valid");
            return T;
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 2);
            //return null;
            //System.out.println("EOL expected");
        }
    }
    
    // Method for regularSystem NonTerminal
    private StateMachine regularSystem() throws Exception
    {
        StateMachine T;
        if (scanner.isAuxillary(scanner.currentToken()))
        {
            if (scanner.isAuxStmt())
            {
                String temp;
                scanner.NextAuxToken();
                temp = scanner.getAuxToken();
                scanner.NextToken();
                //pout.println("<regularSystem> -> <auxStmt> <auxTail>");
                auxStmt(temp);
                return auxTail();
            }
            else
            {
                //pout.println("<regularSystem> -> <regExp> eol");
                T = regExp();
                if (scanner.isEOL(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
                {
                    //System.out.println("Entered Expression is Valid");
                    scanner.NextToken();
                    return T;
                }
                else
                {
                    //pout.close();
                    throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 3);
                    //return null;
                    //System.out.println("EOL expected");
                }
            }
        }
        else if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken()) 
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken())))
        {
            //System.out.println("Doing Rule 1 : <start> --> <regExp> 'EOL'");
            //pout.println("<regularSystem> -> <regExp> eol");
            T = regExp();
            if (scanner.isEOL(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
            {
                //System.out.println("Entered Expression is Valid");
                scanner.NextToken();
                return T;
            }
            else
            {
                //pout.close();
                throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 3);
                //return null;
                //System.out.println("EOL expected");
            }
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //return null;
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for auxStmt NonTerminal
    private void auxStmt(String s) throws Exception
    {
        //pout.println("<auxStmt> -> auxillary = <regExp>");
        StateMachine T;
        scanner.NextToken(); // gets next token after '='
        T = regExp();
        if (scanner.isEOL(scanner.currentToken())) /*|| (scanner.isLambda(scanner.currentToken())))*/
        {
            //System.out.println();
            scanner.NextToken();
            symbolTable.insert(s, T);
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 2);
            //System.out.println("EOL expected");
        }
    }
    
    // Method for auxTail NonTerminal
    private StateMachine auxTail() throws Exception
    {
        StateMachine T;
        if (scanner.isAuxillary(scanner.currentToken()))
        {
            if (scanner.isAuxStmt())
            {
                String temp;
                scanner.NextAuxToken();
                temp = scanner.getAuxToken();
                scanner.NextToken();
                //pout.println("<auxTail> -> <auxStmt> <auxTail>");
                auxStmt(temp);
                return auxTail();
            }
            else
            {
                //pout.println("<auxTail> -> <regExp> eol");
                T = regExp();
                if (scanner.isEOL(scanner.currentToken()))/* || scanner.isLambda(scanner.currentToken()))*/
                {
                    //System.out.println("Entered Expression is Valid");
                    scanner.NextToken();
                    return T;
                }
                else
                {
                    //pout.close();
                    throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 2);
                    //return null;
                    //System.out.println("EOL expected");
                }
            }
        }
        else if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken()) 
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken())))
        {
            //System.out.println("Doing Rule 1 : <start> --> <regExp> 'EOL'");
            //pout.println("<auxTail> -> <regExp> eol");
            T = regExp();
            if (scanner.isEOL(scanner.currentToken())) /*|| scanner.isLambda(scanner.currentToken()))*/
            {
                //System.out.println("Entered Expression is Valid");
                scanner.NextToken();
                return T;
            }
            else
            {
                //pout.close();
                throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 2);
                //return null;
                //System.out.println("EOL expected");
            }
        }
        else if (scanner.isEOF(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
        {
            // auxTail goes to lambda
            //pout.println("<auxTail> -> lambda");
            return null;
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //return null;
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for regExp NonTerminal
    private StateMachine regExp() throws Exception
    {
        StateMachine T;
        //StateMachine U;
        if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken()) 
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
            || scanner.isAuxillary(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 2 : <regExp> --> <orOperand> <orTail>");
            //pout.println("<regExp> -> <orOperand> <orTail>");
            T = orOperand();
            return orTail(T);
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for orOperand NonTerminal
    private StateMachine orOperand() throws Exception
    {
        StateMachine T;
        if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken()) 
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
            || scanner.isAuxillary(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 3 : <orOperand> --> <catOperand> <catTail>");
            //pout.println("<orOperand> -> <catOperand> <catTail>");
            T = catOperand();
            return catTail(T);
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for orTail NonTerminal
    private StateMachine orTail(StateMachine U) throws Exception
    {
        StateMachine T;
        StateMachine Union;
        if (scanner.isUnion(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 4 : <orTail> --> '|' <orOperand> <orTail>");
            //pout.println("<orTail> -> | <orOperand> <orTail>");
            scanner.NextToken();
            T = orOperand();
            //Union = f.union(U, T);
            Union = f2.union(U, T);
            return orTail(Union);   //should pass Union, just passing T for now
        }
        else if (scanner.isEOL(scanner.currentToken()) || scanner.isRightParen(scanner.currentToken())
                 || scanner.isLambda(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 5 : <orTail> --> Lambda");
            //pout.println("<orTail> -> lambda");
            //scanner.NextToken();
            return U;   // return parameter with no changed made to it
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 4);
            //System.out.println("EOL or ')' Expected");
        }
    }
    
    // Method for catOperand NonTerminal
    private StateMachine catOperand() throws Exception
    {
        StateMachine T;
        if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken())
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
            || scanner.isAuxillary(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 6 : <catOperand> --> <starOperand> <startail>");
            //pout.println("<catOperand> -> <starOperand> <starTail>");
            T = starOperand();
            return starTail(T);
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for catTail NonTerminal
    private StateMachine catTail(StateMachine U) throws Exception
    {
        StateMachine T;
        StateMachine Cat;
        if (scanner.isCat(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 7 : <catTail> --> '.' <catOperand> <catTail>");
            //pout.println("<catTail> -> . <catOperand> <catTail>");
            scanner.NextToken();
            T = catOperand();
            Cat = f.concatenation(U, T);
            //Cat = f2.concatenation(U, T);
            return catTail(Cat);  // just passing T for now
        }
        else if (scanner.isEOL(scanner.currentToken()) || scanner.isRightParen(scanner.currentToken()) 
                 || scanner.isUnion(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 8 : <catTail> --> Lambda");
            //pout.println("<catTail> -> lambda");
            //scanner.NextToken();
            return U;    // return parameter with no changes made to it
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 5);
            //System.out.println("EOL or ')' or '|' Expected");
        }
    }
    
    // Method for starOperand NonTerminal
    private StateMachine starOperand() throws Exception
    {
        
        if ((scanner.isAlph(scanner.currentToken()) || scanner.isLeftParen(scanner.currentToken()) 
            || scanner.isEmpty(scanner.currentToken()) || scanner.isLambda(scanner.currentToken()))
            || scanner.isAuxillary(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 9 : <starOperand> --> <regUnit>");
            //pout.println("<starOperand> -> <regUnit>");
            return regUnit();
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
            //System.out.println("Syntax Error at Location " + scanner.getStringIndex());
        }
    }
    
    // Method for starTail NonTerminal
    private StateMachine starTail(StateMachine U) throws Exception
    {
        StateMachine star;
        if (scanner.isStar(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 10 : <starTail> --> '*'");
            //pout.println("<starTail> -> * <starTail>");
            scanner.NextToken();
            //star = f.star(U);
            star = f2.star(U);
            return starTail(star);         // U should be passed to next star Tail
        }
        else if ((scanner.isEOL(scanner.currentToken()) || scanner.isRightParen(scanner.currentToken()) 
                 || scanner.isUnion(scanner.currentToken()) || scanner.isCat(scanner.currentToken()))
                 || scanner.isLambda(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 11 : <starTail> --> Lambda");
            //scanner.NextToken();
            //pout.println("<starTail> -> lambda");
            return U;    // pass back param with no alterations made
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 6);
            //System.out.println("EOL or ')' or '|' or '.' Expected");
        }
    }
    
    // Method for regUnit Nonterminal
    private StateMachine regUnit() throws Exception
    {
        StateMachine T;
        
        if (scanner.isLambda(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 13 : <regUnit> --> EmptyString");
            //pout.println("<regUnit> -> empty-string");
            //T = f.createLambda();
            T = f.createSimple(StateMachine.EMPTY_SYMBOL.charValue());
            scanner.NextToken();
            return T;
        }
        else if (scanner.isAlph(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 12 : <regUnit> --> Alph");
            //pout.println("<regUnit> -> alphanumeric");
            T = f.createSimple(scanner.currentToken());
            scanner.NextToken();
            return T;
        }
        else if (scanner.isLeftParen(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 14 : <regUnit> --> '(' <regExp> ')'");
            //pout.println("<regUnit> -> ( <regExp> )");
            scanner.NextToken();
            T = regExp();
            if (scanner.isRightParen(scanner.currentToken()))
            {
                scanner.NextToken();
                return T;
            }
            else
            {
                //pout.close();
                throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 7);
                //System.out.println("')' expected");
                //isValid = false;
            }
        }
        else if (scanner.isEmpty(scanner.currentToken()))
        {
            //System.out.println("Doing Rule 12.1 : <regUnit> --> EmptySet");
            //pout.println("<regUnit> -> empty-set");
            scanner.NextToken();
            return f.createEmptySet();
        }
        else if (scanner.isAuxillary(scanner.currentToken()))
        {
            //pout.println("<regUnit> -> auxillary");
            scanner.NextAuxToken();
            scanner.NextToken();
            //System.out.println(scanner.getAuxToken());
            T = symbolTable.lookUp(scanner.getAuxToken());
            return T;
        }
        else
        {
            //pout.close();
            throw new ParsingException(scanner.getStringIndex(), scanner.getInputString(), 0);
        }
    }
}
