 


/**
 * Write a description of class RegExpression here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
import java.util.*;
import java.io.*;
import java.awt.*;
public class RegExpression
{
    private String name = "",ebnfName ="";//language text
    private String language = "";
    private String exampLang = "";

    /*these data structures are used for standard expressions */
    private Vector explSteps;  //vector that will hold steps of each
                               //explanation
    private Vector exprSteps;   //holds each step in expression steps
    private Vector auxExp;      //all aux expressions to make up expression
    private String standardFinalExpression;   //what final expression is

    /* for each language/expression you can have more that one set
       of explanations, put each vector of explanations in 
       linked list
    */
    private LinkedList list;  //linked list of vectors of explanations
    private LinkedList list2; //linked list of expr. steps

    /*these data structures are for EBNF */

    private Vector ebnfExplSteps;   //vector that will hold steps of each
                                //explanation
    private Vector ebnfExprSteps;   //holds each step in expression steps
    private Vector ebnfAuxExp;      //all aux expressions to make up expression
    private String ebnfFinalExpression;   //what final expression is

    /* for each language/expression you can have more that one set
       of explanations, put each vector of explanations in 
       linked list
    */
    private LinkedList ebnfList;  //linked list of vectors of explanations
    private LinkedList ebnfList2; //linked list of expr. steps


   /* fonts for text areas, will need to put in XML doc */
    String langFontName,explanationFontName,expressionFontName;
    int langFontSize,explanationFontSize,expressionFontSize;
    int langFontStyle,explanationFontStyle,expressionFontStyle;
    private String langFontColor,expressionFontColor,explanationFontColor;

    /*fonts for ebnf */
    String ebnfExplanationFontName,ebnfExpressionFontName;
    int ebnfExplanationFontSize,ebnfExpressionFontSize;
    int ebnfExplanationFontStyle,ebnfExpressionFontStyle;

    private String ebnfExplanationFontColor,ebnfExpressionFontColor;
    private boolean auxillary,example,standard,EBNF;


    public RegExpression()
    {
       explSteps = new Vector();
       exprSteps = new Vector();
       auxExp = new Vector();

       /*ebnf vectors */
       ebnfExplSteps = new Vector();  
       ebnfExprSteps = new Vector();
       ebnfAuxExp = new Vector();
 
       standardFinalExpression = "";
       ebnfFinalExpression = "";
       language = "";

       
       list = new LinkedList();
       list2 = new LinkedList();

       ebnfList = new LinkedList();
       ebnfList2 = new LinkedList();

     

       auxillary = false;
       example = false;

      
    }
   
    /*****************************************************************
      use these functions for XML file, will knwo when regualr expressions
      are going to be used as examples and which ones will be used
      for examples
    */
    public boolean getExample()
    {
       return example;
    }
   
    public void setExample(boolean ex)
    {
       example = ex;
    }
    
    /* if the reg expression is a standard reg expression */
    public void setStandard(boolean s)
    {
        standard = s;
    }
    
    /* if the reg expression is an EBNF expression */
    public void setEBNF(boolean s)
    {
        EBNF = s;
    }
    
    public boolean getAuxillary()
    {
       return auxillary;
    }
    
    public void setAuxillary(boolean aux)
    {
       auxillary = aux;
    }
    
    /*called when uer loads in an existing xml file, when loadin an
     * example, remove this vector from list, will be replaced when
     * user edits the read in file
     */
    public void removeExprFromList(int num)
    {
       list2.remove(num-1);
    }
    
    public void removeEbnfExprFromList(int num)
    {
       ebnfList2.remove(num-1);
    }
    
    public void removeExplFromList(int num)
    {
       list.remove(num-1);
    }
    
    public void removeEbnfExplFromList(int num)
    {
       ebnfList.remove(num-1);
    }
    
    /*these 2 functions are called when user edits an existing xml
     * file, then add the edited verison to list
     */
    public void addEditedExprToList(int num)
    {
        /*if the last element is the empty string, erase */
        if(((String)exprSteps.lastElement()).equals("")) 
        {
            exprSteps.remove(exprSteps.lastElement());
        }
        list2.remove(num-1);
        list2.add(num-1,exprSteps);
        //reset vectors
        exprSteps = new Vector();
        
    }
    
    public void addEditedEbnfExprToList(int num)
    {
          /*if the last element is the empty string, erase */
        if(((String)ebnfExprSteps.lastElement()).equals("")) 
        {
            ebnfExprSteps.remove(ebnfExprSteps.lastElement());
        }
        ebnfList2.remove(num-1);
        ebnfList2.add(num-1,ebnfExprSteps);
     
        //reset  vector
        ebnfExprSteps = new Vector();
    }
    
    public void addEditedExplToList(int num)
    {
          /*if the last element is the empty string, erase */
        if(((String)explSteps.lastElement()).equals("")) 
        {
            explSteps.remove(explSteps.lastElement());
        }
        list.remove(num-1);
        list.add(num-1,explSteps);
     
        explSteps = new Vector();
      
    }
    
    public void addEditedEbnfExplToList(int num)
    {
           /*if the last element is the empty string, erase */
        if(((String)ebnfExplSteps.lastElement()).equals("")) 
        {
            ebnfExplSteps.remove(ebnfExplSteps.lastElement());
        }
        ebnfList.remove(num-1);
        ebnfList.add(num-1,ebnfExplSteps);
     
        ebnfExplSteps = new Vector();
    }
    
    /*add vector of explanations to linked list */
    public void addExplToList()
    {
       list.add(explSteps);
       //explSteps = new Vector();
    }
    
    public void resetExplSteps()
    {
        explSteps = new Vector();
    }
    
    /*add vector of explanations to linked list */
    public void addExprToList()
    {
        list2.add(exprSteps);
        //exprSteps = new Vector();  
    }
    
    public void resetExprSteps()
    {
        exprSteps = new Vector();
    }
    
    /*add vector of explanations to Ebnf linked list */
    public void addExplToEbnfList()
    {
       ebnfList.add(ebnfExplSteps);
       //ebnfExplSteps = new Vector();
    }
    
    public void resetEbnfExplSteps()
    {
        ebnfExplSteps = new Vector();
    }
    
    /*add vector of expression steps for EBNF to linked list
     of step vectors
    */
    public void addExprToEbnfList()
    {
        ebnfList2.add(ebnfExprSteps);
        ebnfExprSteps = new Vector();
    }
    
    public void resetEbnfExprSteps()
    {
        ebnfExprSteps = new Vector();
    }
    
    /*set the font names for all the text fields, needs to be 
      an element in XML file
    */
    public void setLangFontAttributes(Font langFont,String c)
    {
        langFontName = langFont.getName();
        langFontStyle = langFont.getStyle();
        langFontSize = langFont.getSize();
        langFontColor = c;
    }
    
    public Font getLangFontAttributes()
    {
       Font langFont = new Font(langFontName,langFontStyle,langFontSize);
       return langFont;
    }
    
    public String getLangFontColor()
    {
       return langFontColor;
    }
    
    public String getExprFontColor()
    {
       return expressionFontColor;
    }
    
    public String getExplFontColor()
    {
       return explanationFontColor;
    }
    
    public Font getExprFontAttributes()
    {
        Font exprFont = new Font(expressionFontName,expressionFontStyle,
                                              expressionFontSize);
        return exprFont;
    }
    
    public Font getExplFontAttributes()
    {
        Font explFont = new Font(explanationFontName,explanationFontStyle,
                                              explanationFontSize);
        return explFont;
    }
    
    public void setExplanationFontAttributes(Font explFont,String c)
    {
         explanationFontName = explFont.getName();
         explanationFontStyle = explFont.getStyle();
         explanationFontSize = explFont.getSize();
         explanationFontColor = c;
    }
    
    public void setExpressionFontAttributes(Font exprFont,String c)
    {
         expressionFontName = exprFont.getName();
         expressionFontStyle = exprFont.getStyle();
         expressionFontSize = exprFont.getSize();
         expressionFontColor = c;
    }
    
    public void setEbnfExplanationFontAttributes(Font explFont,String c)
    {
         ebnfExplanationFontName = explFont.getName();
         ebnfExplanationFontStyle = explFont.getStyle();
         ebnfExplanationFontSize = explFont.getSize();
         ebnfExplanationFontColor = c;
    }
    
    public void setEbnfExpressionFontAttributes(Font exprFont,String c)
    {
         ebnfExpressionFontName = exprFont.getName();
         ebnfExpressionFontStyle = exprFont.getStyle();
         ebnfExpressionFontSize = exprFont.getSize();
         ebnfExpressionFontColor = c;
    }
    
    public Font getEbnfExprFontAttributes()
    {
       Font f = new Font(ebnfExpressionFontName,ebnfExpressionFontStyle,
                                     ebnfExpressionFontSize);
       return f;
    }
    public Font getEbnfExplFontAttributes()
    {
       Font f = new Font(ebnfExplanationFontName,ebnfExplanationFontStyle,
                                     ebnfExplanationFontSize);
       return f;
    }
    public String getEbnfExprFontColor()
    {
       return ebnfExpressionFontColor;
    }
    public String getEbnfExplFontColor()
    {
       return ebnfExplanationFontColor;
    }
    public void setLangFontColor(String c)
    {
       langFontColor = c;
    }
    public void setExplanationFontColor(String c)
    {
       explanationFontColor = c;
    }
    public void setExpressionFontColor(String c)
    {
       expressionFontColor = c;
    }
    
    /* what the expression is for given language stardard expression */
    public void setFinalExpression(String finalExp,String expType)
    {
 
       if(expType.equals("standard"))
          standardFinalExpression = finalExp;

       else
          ebnfFinalExpression = finalExp;
    }
    
    public String getFinalExpression()
    {
       return standardFinalExpression;
    }
  
    /*return the EBNF expression for the given language */
    public String getFinalEbnfExpression()
    {
       return ebnfFinalExpression;
    }
    
    public void setName(String name)
    {
       this.name = name;
   
    }
    
    public void setEbnfName(String name)
    {
       ebnfName = name;
    }
    
    public void setLanguage(String language)
    {
       this.language = language;
    }
    
    // Added by Brad Pascoe on 6/23/03
    public void setExampLang(String s)
    {
        exampLang = s;
    }
    
    /*if regular expression is made up of one or more auxillary
      expressions.  The auxillary expressions will be in vector
      auxExp.
    */
    public void addAuxExp(AuxillaryExpression exp,String expType)
    {
        if(expType.equals("standard"))
           auxExp.addElement(exp);

        else
           ebnfAuxExp.addElement(exp);   
    }
    
    /*if regular expression is made up of one or more auxillary
      expressions.  The auxillary expressions will be in vector
      ebnfauxExp.  if expression type is EBNF
    */
    public void addAuxEbnfExp(AuxillaryExpression exp)
    {
        ebnfAuxExp.addElement(exp);
    }
    
    /*this returns an aux expression object from vector
      of auxillary expressions.
    */
    public AuxillaryExpression getAuxExpression(int index)
    {
        return (AuxillaryExpression)auxExp.elementAt(index);
    }
    
    /*this returns an aux expression object from vector
      of auxillary expressions. - EBNF expression
    */
    public AuxillaryExpression getAuxEbnfExpression(int index)
    {
        return (AuxillaryExpression)ebnfAuxExp.elementAt(index);
    }

    /*this function adds an explanation for a particular expression
      gets added when arrow button gets hit.  Text area gets added
      to vector of explanations.  For standard expression type
    */
    public void addExplStep(String explanation)
    {
        explSteps.addElement(explanation);
    }
    
    public void addExprStep(String expression)
    {
        exprSteps.addElement(expression);
    }
    
    /*this function adds an explanation for a particular expression
      gets added when arrow button gets hit.  Text area gets added
      to vector of explanations.  For EBNF expression type
    */
    public void addEbnfExplStep(String explanation)
    {
        ebnfExplSteps.addElement(explanation);

    }
    
    public void addEbnfExprStep(String expression)
    {
        ebnfExprSteps.addElement(expression);
    }

    /*this just returns the language, needed for if user hits open button
      or open from file menu, can reload an expression, to change
    */
    public String getLanguage()
    {
      return language;
    }
    
    public String getExampLang()
    {
        return exampLang;
    }
    
    public String getName()
    {
       return name;
    }
    
    public String getEbnfName()
    {
       return ebnfName;
    }
    
    /*this is if user changes one of the steps, need to remove from vector
      and replace with current text in text area.  Called from example
      tabbed pane.  For standard expression Type
    */
    public String removeExprStep(int index)
    {
        return (String)exprSteps.remove(index);
    }
    public String removeExplStep(int index)
    {
        return (String)explSteps.remove(index);
    }
    /*this is if user changes one of the steps, need to remove from vector
      and replace with current text in text area.  Called from example
      tabbed pane.  For EBNF expression Type
    */
    public String removeEbnfExprStep(int index)
    {
        return (String)ebnfExprSteps.remove(index);
    }
    public String removeEbnfExplStep(int index)
    {
        return (String)ebnfExplSteps.remove(index);
    }
    /*these get step functions are if hitting back and forward arrow
      in example tabbed pane, reset the text.  Get text and reset the
      text area  - standard expression type
    */
    public String getExprStep(int index)
    {
       return (String)exprSteps.elementAt(index);
    }
    public String getExplStep(int index)
    {
       return (String)explSteps.elementAt(index);
    }
    /*these get step functions are if hitting back and forward arrow
      in example tabbed pane, reset the text.  Get text and reset the
      text area  - EBNF expression type
    */
    public String getEbnfExprStep(int index)
    {
       return (String)ebnfExprSteps.elementAt(index);
    }
    public String getEbnfExplStep(int index)
    {
       return (String)ebnfExplSteps.elementAt(index);
    }
    /*returns the size of the vector, using this for counters
      standard expressiontype
    */
    public int getExprStepSize()
    {
   
       return exprSteps.size();
    }
    public int getExplStepSize()
    {
       return explSteps.size();
    }
     /*returns the size of the vector, using this for counters
       EBNF expression type
   */
    public int getEbnfExprStepSize()
    {
       return ebnfExprSteps.size();
    }
    public int getEbnfExplStepSize()
    {
       return ebnfExplSteps.size();
    }
    /*****************************************************************
      used by step function, need to get the vector from linked list
      of steps.  Standard expression type
    ******************************************************************/
    public Vector getExprVectorFromList(int listIndex)
    {

       Vector stepVector = (Vector)list2.get(listIndex-1);
       return stepVector;
    }
    
    /*this will return a vector of explanations for a given expression
      if the user wants to load or run a particular example will 
      need to know which set of explanations and expressions
      steps that go with that expression that is chosen - standard
      expression type
    */
    public Vector getExplVectorFromList(int listIndex)
    {
        Vector stepVector = (Vector)list.get(listIndex-1);
        return stepVector;
    }
    
    /*public void printExplVector()
    {
        for (int i = 0; i < explSteps.size(); i++)
        {
            System.out.println(explSteps.elementAt(i));
        }
    }*/
    
    /*this function is called when user loads in an existing xml file
     * need to set all fields so can be used in applicatioins
     */
    public void setStepVector(Vector expressions,Vector explanations)
    {
        exprSteps = new Vector();
        explSteps = new Vector();
        exprSteps = (Vector)expressions.clone();
        explSteps = (Vector)explanations.clone();
    }
    
    public void setEbnfStepVector(Vector expressions,Vector explanations)
    {
       ebnfExprSteps= (Vector)expressions.clone();
       ebnfExplSteps= (Vector)explanations.clone();
    }
    
    public Vector getExplVector()
    {
        return explSteps;
    }
    
    public Vector getExprVector()
    {
        return exprSteps;
    }
     /*****************************************************************
      used by step function, need to get the vector from linked list
      of steps.  EBNF expre type
    ******************************************************************/
    public Vector getEbnfExprVectorFromList(int listIndex)
    {

       Vector stepVector = (Vector)ebnfList2.get(listIndex-1);
       return stepVector;
    }
    public Vector getEbnfExprVector()
    {
        return ebnfExprSteps;
    }
    /*this will return a vector of explanations for a given expression
      if the user wants to load or run a particular example will 
      need to know which set of explanations and expressions
      steps that go with that expression that is chosen
   */
    public Vector getEbnfExplVectorFromList(int listIndex)
    {
        Vector stepVector = (Vector)ebnfList.get(listIndex-1);
        return stepVector;
    }
    public Vector getEbnfExplVector()
    {
        return ebnfExplSteps;
    }
    public Vector getAuxillaryVector()
    {
        return auxExp;
    }
    public Vector getEbnfAuxillaryVector()
    {
       return ebnfAuxExp;
    }
    /*this just returs text that will be placed in text field on 
      example tabbed pane, used when arrows are hit
    */
    public String getExprStepElement(int index)
    {
       return (String)exprSteps.elementAt(index);
    }
    public String getExplStepElement(int index)
    {
       return (String)explSteps.elementAt(index);
    }
    /*this just returs text that will be placed in text field on 
      example tabbed pane, used when arrows are hit
    */
    public String getEbnfExprStepElement(int index)
    {
       return (String)ebnfExprSteps.elementAt(index);
    }
    public String getEbnfExplStepElement(int index)
    {
       return (String)ebnfExplSteps.elementAt(index);
    }

    /*when user hits forward arrow button that text that represents
      a step in expression, add to vector of expression steps
      standard expression type
    */
    public void setExprStep(String step,int index)
    {
       exprSteps.set(index,step);
    }
    public void setExplStep(String step,int index)
    {
       explSteps.set(index,step);
    }
    /*when user hits forward arrow button that text that represents
      a step in expression, add to vector of expression steps
      EBNF type
    */
    public void setEbnfExprStep(String step,int index)
    {
       ebnfExprSteps.add(index,step);
    }
    public void setEbnfExplStep(String step,int index)
    {
       ebnfExplSteps.add(index,step);
    }
    public String printAuxExp()
    {
        return auxExp.toString();
    }
    public String printEbnfAuxExp()
    {
        return ebnfAuxExp.toString();
    }
    public String printExprList()
    {
       return list2.toString();
    }
    public String printExplList()
    {
       return list.toString();
    }
    
    /*this prints out the vector of expression steps, standard exp type
       used as a debugging tool
    */
    public String printExprVector()
    {
        return exprSteps.toString();
    }
    public String printExplVector()
    {
        return explSteps.toString();
    }
    
    /*this prints out the vector of expression steps, EBNF exp type
     used as a debugging tool
    */
    public String printEbnfExprVector()
    {
        return ebnfExprSteps.toString();
    }
    public String printEbnfExplVector()
    {
        return ebnfExplSteps.toString();
    }
    
    /*prints the number of explanations sets for standard expression type */
    public int numExplanations()
    {
       return list.size();
    } 
    
    /*prints the number of explanations sets for EBNF expression type */
    public int numEbnfExplanations()
    {
       return ebnfList.size();
    } 
    
    /*********************************************************************
     This function writes everything that is associated with a regular
     expression exercise or example to an XML file.  Each expression
     has a language, language Font attributes, auxillary expressions that 
     make up a regualar expression.  Explanation steps that help explaian
     how one might think of defining a reg expression.
    **********************************************************************/
    public void writeExpression(PrintWriter out)
    {
        AuxillaryExpression exp;
        Vector explanationSteps;
        Vector expressionSteps;
       
        out.println("<regExpression>");  //opening tag
     
        /*expression is either an example or not, set this att */
        out.println("<example>" + example +"</example>");
        /*write language and all its attribures */
        out.println("<language>");
        if (example == true)
            out.println("<langText>" + exampLang + "</langText>");
        else
            out.println("<langText>" + language + "</langText>");
        
        out.println("<fontAttributes>");
        out.println("<fontName>" + langFontName + "</fontName>");
        out.println("<fontStyle>" + langFontStyle + "</fontStyle>");
        out.println("<fontSize>" + langFontSize + "</fontSize>");
        out.println("<fontColor>" + langFontColor + "</fontColor>");
        out.println("</fontAttributes>");
        out.println("</language>");
       
        /*this expression is an example */
        if(example==true)
        {
            if(standard == true) //standard reg expression 
            {
               /*get all of the steps for this example
                 go thru linked list of explanations, also
                 font attributes for the text of explanations
                */
                out.println("<standard>");   
                out.println("<explFontAttributes>");
                out.println("<explFontName>" + explanationFontName + 
                                             "</explFontName>");
                out.println("<explFontStyle>" +explanationFontStyle +
                                         "</explFontStyle>");
                out.println("<explFontSize>" + explanationFontSize +
                                          "</explFontSize>");
                out.println("<expFontColor>" + explanationFontColor +
                                          "</expFontColor>");
                out.println("</explFontAttributes>");
                
                for(int i =0; i <list.size(); i++)
                {
                   explanationSteps = (Vector)list.get(i);
             
                   out.println("<explanationSteps>");
                   
     
                  /*this is vector of all steps for one linked list
                    element 
                  */
                  for(int j =0; j <explanationSteps.size();j++)
                  {
                     out.println("<step>");
                     out.println((String)explanationSteps.elementAt(j));
                     out.println("</step>");
                  }
                  out.println("</explanationSteps>");
               }
             /*
                print out all the sets of steps to explain how to 
                define reg expression.  There is a linked list of vectors
                the vector has steps to make reg expression, which are
                in linked list2
             */
              out.println("<exprFontAttributes>");
              out.println("<exprFontName>" + expressionFontName + 
                                             "</exprFontName>");
              out.println("<exprFontStyle>" +expressionFontStyle +
                                         "</exprFontStyle>");
              out.println("<exprFontSize>" + expressionFontSize +
                                          "</exprFontSize>");
              out.println("<exprFontColor>" + expressionFontColor +
                                         "</exprFontColor>");
              out.println("</exprFontAttributes>");
              
              for(int i =0; i <list2.size(); i++)
              {
             
                  expressionSteps = (Vector)list2.get(i);
                  out.println("<expressionSteps>");
                 
     
                  /*this vector has each reg expression step */
                  for(int j =0; j<expressionSteps.size();j++)
                  {
                     out.println("<expStep>");
                     out.println((String)expressionSteps.elementAt(j));
                     out.println("</expStep>");
                  }
                  out.println("</expressionSteps>");
              }//end if list2 is true
              out.println("</standard>");
            }//emd of standard os true

            if(EBNF == true)
            {
               /*get all of the steps for this example
                 go thru linked list of explanations, also
                 font attributes for the text of explanations
                */
              out.println("<EBNF>");
              out.println("<ebnfExplFontAttributes>");
              out.println("<ebnfExplFontName>" + ebnfExplanationFontName + 
                                             "</ebnfExplFontName>");
              out.println("<ebnfExplFontStyle>" +ebnfExplanationFontStyle +
                                         "</ebnfExplFontStyle>");
              out.println("<ebnfExplFontSize>" + ebnfExplanationFontSize +
                                          "</ebnfExplFontSize>");
              out.println("<ebnfExpFontColor>" + ebnfExplanationFontColor +
                                          "</ebnfExpFontColor>");
              out.println("</ebnfExplFontAttributes>");
     
              for(int i =0; i <ebnfList.size(); i++)
              {
                  explanationSteps = (Vector)ebnfList.get(i);
      
                  out.println("<ebnfExplanationSteps>");
                  
            
                  for(int j =0; j <explanationSteps.size();j++)
                  {
                     out.println("<ebnfStep>");
                     out.println((String)explanationSteps.elementAt(j));
                     out.println("</ebnfStep>");
                  }

                  out.println("</ebnfExplanationSteps>");
               }


             /*
                print out all the sets of steps to explain how to 
                define reg expression.  There is a linked list of vectors
                the vector has steps to make reg expression, which are
                in linked list2
             */
             out.println("<ebnfExprFontAttributes>");
             out.println("<ebnfExprFontName>" + ebnfExpressionFontName + 
                                             "</ebnfExprFontName>");
             out.println("<ebnfExprFontStyle>" +ebnfExpressionFontStyle +
                                         "</ebnfExprFontStyle>");
             out.println("<ebnfExprFontSize>" + ebnfExpressionFontSize +
                                          "</ebnfExprFontSize>");
             out.println("<ebnfExprFontColor>" + ebnfExpressionFontColor +
                                         "</ebnfExprFontColor>");
              out.println("</ebnfExprFontAttributes>");
              for(int i =0; i <ebnfList2.size(); i++)
              {
             
                  expressionSteps = (Vector)ebnfList2.get(i);
                  out.println("<ebnfExpressionSteps>");
                 
                  for(int j =0; j<expressionSteps.size();j++)
                  {
                     out.println("<ebnfExpStep>");
                     out.println((String)expressionSteps.elementAt(j));
                     out.println("</ebnfExpStep>");
                  }
                  out.println("</ebnfExpressionSteps>");
              }
            
              out.println("</EBNF>");
            }//emd of ebnf os true
          
        }//if example is true
/*********************EXERCISE**************************************/
        else // not an example is an exercise 
        {
           String temp;
           out.println("<auxillary>" + auxillary + "</auxillary>");
           if(standard == true)
           {
              
             
             /*if the expression is made up of auxillary expressions */
             if(auxillary==true) 
             {
                out.println("<standard>");
                
                out.println("<exprName>" + name + "</exprName>");
                
                /* define reg expression e.g 1*0**/
                //temp = standardFinalExpression.replaceAll("<", "&lt;");
                //temp = temp.replaceAll(">", "&gt;");
                out.println("<standardDefinition>" + standardFinalExpression +
                             "</standardDefinition>");
                out.println("<auxillaryExpression>");
         
               /*however many auxillary expressions, made up of
                 auxExp many auxillary expressions
               */
               for(int i =0; i < auxExp.size(); i++)
               {
                  exp = (AuxillaryExpression)auxExp.elementAt(i);
                  out.println("<auxExpression>");
                  //temp = removePointy(exp.getName());
                  temp = exp.getName().replaceAll("<", "&lt;");
                  temp = temp.replaceAll(">", "&gt;");
                  out.println("<name>" + temp + "</name>");
                  //temp = removePointy(exp.getExpression());
                  //temp = exp.getExpression().replaceAll("<", "&lt;");
                  //temp = temp.replaceAll(">", "&gt;");
                  out.println("<aux>" + exp.getExpression() + "</aux>");
                  out.println("</auxExpression>");
               }
               out.println("</auxillaryExpression>");
               out.println("</standard>");
             }//end if auxillary == true
             else
             {
                 //temp = removePointy(standardFinalExpression);
                 out.println("<standardDefinition>" + standardFinalExpression +
                             "</standardDefinition>");
             }
       
          }//end if standard is true
          if(EBNF == true)
          {
          
            /*if the expression is made up of auxillary expressions */
             if(auxillary==true) 
             {
                out.println("<EBNF>");
                out.println("<ebnfName>" + ebnfName + "</ebnfName>");
                 /* define reg expression e.g 1*0**/
                //temp = removePointy(ebnfFinalExpression);
                //temp = ebnfFinalExpression.replaceAll("<", "&lt;");
                //temp = temp.replaceAll(">", "&gt;");
                out.println("<ebnfDefinition>" + ebnfFinalExpression +
                             "</ebnfDefinition>");
                out.println("<ebnfAuxillaryExpression>");
          
               /*however many auxillary expressions, made up of
                 auxExp many auxillary expressions
               */
               for(int i =0; i < ebnfAuxExp.size(); i++)
               {
                  exp = (AuxillaryExpression)ebnfAuxExp.elementAt(i);

                  out.println("<ebnfAuxExpression>");
                  //temp = removePointy(exp.getName());
                  temp = exp.getName().replaceAll("<", "&lt;");
                  temp = temp.replaceAll(">", "&gt;");
                  out.println("<ebnfName>" + temp + "</ebnfName>");
                  //temp = removePointy(exp.getName());
                  //temp = exp.getExpression().replaceAll("<", "&lt;");
                  //temp = temp.replaceAll(">", "&gt;");
                  out.println("<ebnfAux>" + exp.getExpression() + "</ebnfAux>");
                  
                  out.println("</ebnfAuxExpression>");
               }
               out.println("</ebnfAuxillaryExpression>");
               out.println("</EBNF>");
             }//end if auxillary == true
             
             else
             {
                 //temp = removePointy(ebnfFinalExpression); 
                 out.println("<ebnfDefinition>" + ebnfFinalExpression +
                             "</ebnfDefinition>");
             }
          } //end if ebnf true
        }
          /*end expression opening tag */
       out.println("</regExpression>");
    }
    
    // This method replaces all '<' with the '&' symbol and '>' with the '@' symbol. 
    //  This is necessary because xml uses the '<' and '>' as tag delimiters.
    public String removePointy(String s)
    {
        String t = s;
        for (int i = 0; i < t.length(); i++)
        {
            if (t.charAt(i) == '<')
            {
                t = t.substring(0, i) + "&" + t.substring(i + 1, t.length());
            }
            if (s.charAt(i) == '>')
            {
                t = t.substring(0, i) + "@" + t.substring(i + 1, t.length());
            }
        }
        
        return t;
    }
   
}
    
