
/**
 * This class handles scanning in a regular expression one token at a time.
 * 
 * @author Brad Pascoe
 * @version 6/10/2003
 */
import java.io.*;
import FSAComponents.*;

public class Reader
{
    //private BufferedReader keyboard;
    private int stringIndex;
    private String inputString;
    private char token;
    private String auxToken;
    private char [] alphabet;
    public static final int SETNEW = 1;
    public static final int KEEPOLD = 0;

	public Reader(String input, int newAlph, char [] alph) throws Exception
	{
	    //keyboard = new BufferedReader(new InputStreamReader(System.in));
	   
	    stringIndex = 0;
	    //inputString = keyboard.readLine();
	    
	    // if newAlph is one then reset alphabet to match current input string
	    if (newAlph == SETNEW)
	    {
	        alphabet = new char [input.length() + 1];
	        setNewAlph(input);
	    }
	    else if (newAlph == KEEPOLD)
	    {
	        alphabet = new char [alph.length];
	        for (int i = 0; i < alph.length; i++)
	        {
	            alphabet[i] = alph[i];
	        }
	    }
	    //printAlph();
	    inputString = input;
	    processInput();
	    //System.out.println(inputString);
	    token = inputString.charAt(stringIndex);
	    auxToken = "";
	}
	
	// loads a new set of alphabet symbols from input string.
	public void setNewAlph(String input) throws Exception
	{
	    Character c = new Character(' ');
	    alphabet[0] = StateMachine.EMPTY_SYMBOL.charValue();
	    int j = 1;
	    for (int i = 0; i < input.length(); i++)
	    {
	        if (isAuxillary(input.charAt(i)))
	        {
	            while (!isAuxillaryClose(input.charAt(i)))
	            {
	                i++;
	                if (i == input.length())
	                {
	                    throw new ParsingException(i, input, 1);
	                }
	            }
	            //i++;
	        }
	        /*else if ((!isRightParen(input.charAt(i))) && (!isLeftParen(input.charAt(i))) &&
	            (!isUnion(input.charAt(i))) && (!isStar(input.charAt(i))) &&
	            (!isLambda(input.charAt(i))) && (!isEquals(input.charAt(i))) &&
	            (!isAlph(input.charAt(i))) && (!isEOL(input.charAt(i))) &&
	            (!isEmpty(input.charAt(i))) && (!isEOF(input.charAt(i))))*/
	        else if ((c.isLetterOrDigit(input.charAt(i))) && (!isAlph(input.charAt(i)))
	                 && (!isLambda(input.charAt(i))))
	        {
	            alphabet[j] = input.charAt(i);
	            j++;
	        }
	    }
	}
	
	public char [] getAlph()
	{
	    return alphabet;
	}
	
	// prints out alphabet
	public void printAlph()
	{
	    for (int i = 0; i < alphabet.length; i++)
	    {
	        System.out.print(alphabet[i] + " ");
	    }
	    System.out.println();
	}
	
	public void NextToken()
	{
	    stringIndex++;
	    token = inputString.charAt(stringIndex);
	}
	
	// moves stringindex past auxtoken, throws exception if auxtoken is not incorrect
	//  form, which is the name of the auxtoken surrounded by '<' and '>'.
	public void NextAuxToken() throws Exception
	{
	    auxToken = "";
	    stringIndex++;
	    while (inputString.charAt(stringIndex) != '>')
	    {
	        auxToken = auxToken + inputString.substring(stringIndex, stringIndex + 1);
	        stringIndex++;
	        if (isEOL(inputString.charAt(stringIndex)))
	        {
	            throw new ParsingException(stringIndex, inputString, 1);
	        }
	    }
	}
	
	public String getAuxToken()
	{
	    return auxToken;
	}
	
	public String getInputString()
	{
	    return inputString;
	}
	
	public char currentToken()
	{
	    return token;
	}
	
	public int getStringIndex()
	{
	    return stringIndex;
	}
	
	// looks ahead in the input string to determine with the current auxtoken is part
	//  of a regular expression, or the start of an auxstmt.
	public boolean isAuxStmt() throws Exception
	{
	    int i = stringIndex + 1;
	    while (!isAuxillaryClose(inputString.charAt(i)))
	    {
	        i++;
	        if (isEOL(inputString.charAt(stringIndex)))
	        {
	            throw new ParsingException(stringIndex, inputString, 1);
	        }
	    }
	    i++;
	    
	    if (isEquals(inputString.charAt(i)))
	    {
	        return true;
	    }
	    else
	    {
	        return false;
	    }
	}
	
	public boolean isAlph(char ch)
	{
	    for (int i = 0; i < alphabet.length; i++)
	    {
	        if (ch == alphabet[i])
	        {
	            return true;
	        }
	    }
	    return false;
	}
	
	public boolean isLeftParen(char ch)
	{
	    if (ch == '(')
	        return true;
	    else
	        return false;
	}
	
	public boolean isRightParen(char ch)
	{
	    if (ch == ')')
	        return true;
	    else
	        return false;
	}
	
	
	public boolean isEmpty(char ch)
	{
	    if (ch == '~')
	        return true;
	    else
	        return false;
	}
	
	public boolean isLambda(char ch)
	{
	    if (ch == 'e')
	        return true;
	    else
	        return false;
	}
	
	public boolean isEOL(char ch)
	{
	    if (ch == ',')
	        return true;
	    else
	        return false;
	}
	
	public boolean isEOF(char ch)
	{
	    if (ch == '$')
	        return true;
	    else
	        return false;
	}
	
	public boolean isUnion(char ch)
	{
	    if (ch == '|')
	        return true;
	    else
	        return false;
	}
	
	public boolean isCat(char ch)
	{
	    if (ch == '.')
	        return true;
	    else
	        return false;
	}
	
	public boolean isStar(char ch)
	{
	    if (ch == '*')
	        return true;
	    else
	        return false;
	}
	
	public boolean isAuxillary(char ch)
	{
	    if (ch == '<')
	        return true;
	    else
	        return false;
	}
	
	public boolean isAuxillaryClose(char ch)
	{
	    if (ch == '>')
	        return true;
	    else
	        return false;
	}
	
	public boolean isEquals(char ch)
	{
	    if (ch == '=')
	        return true;
	    else
	        return false;
	}
	
	// processed input, placing periods where concatenation will occur, and also adds end 
	//  of line characters and end of file characters.
	public void processInput()
	{
	    char current = ' ';
	    char next = ' ';
	    String part1, part2;
	    //inputString = inputString + ";";
	    Character c = new Character(' ');
	    
	    for (int i = 0; i < inputString.length(); i++)
	    {
	        if (c.isWhitespace(inputString.charAt(i)))
	        {
	            inputString = inputString.substring(0, i) + inputString.substring(i + 1);
	            i--;
	        }
	        if (isLambda(inputString.charAt(i)))
	        {
	            inputString = inputString.substring(0,i) + StateMachine.EMPTY_SYMBOL.charValue() +
	                inputString.substring(i + 1);
	                
	        }
	    }
	    
	    for (int i = 0; i < inputString.length() - 1; i++)
	    {
	        current = inputString.charAt(i);
	        next = inputString.charAt(i + 1);
	        if (shouldCat(current, next))
	        {
	            part1 = inputString.substring(0, i + 1);
	            part2 = inputString.substring(i + 1);
	            inputString = part1 + "." + part2;
	        }
	    }
	    
	    if (inputString.charAt(inputString.length() - 1) != ',')
	    {
	        inputString = inputString + ",";
	    }
	    inputString = inputString + "$";
	}
	
	// determines if a concatenation symbol should be placed between char current and char
	//  next
	private boolean shouldCat(char current, char next)
	{
	    if ((isAlph(current) && isAlph(next)) || (isAlph(current) && isLeftParen(next)) 
	            || (isStar(current) && isAlph(next)) || (isStar(current) && isLeftParen(next))
	            || (isRightParen(current) && isAlph(next)) || (isRightParen(current) && isLeftParen(next))
	            || (isAlph(current) && isAuxillary(next)) || (isStar(current) && isAuxillary(next))
	            || (isRightParen(current) && isAuxillary(next)) || (isAuxillaryClose(current) && isAuxillary(next))
	            || (isAuxillaryClose(current) && isLeftParen(next)) || (isAuxillaryClose(current) && isAlph(next)))
	    {
	        return true;
	    }
	    else
	    {
	        return false;
	    }         
	}
}
